
IF NOT  EXISTS (SELECT 1 FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[EST_PROD_FARMACIA_POPULAR]') AND type in (N'U'))
BEGIN

CREATE TABLE EST_PROD_FARMACIA_POPULAR(
	[CD_EMP] [int] NOT NULL,
	[CD_PROD] [int] NOT NULL,
	[QT_COMPR_EMB_CX] [money] NOT NULL,
	[CD_USU] [int] NOT NULL,
	[DT_CAD] [datetime] NOT NULL,
	[EAN_PADRAO] [varchar](50) NOT NULL,
	[VLR_PROD] [money] NOT NULL,
	[FLAG_TIPO_PRECO] [int] NOT NULL,
	[CD_FILIAL] [int] NOT NULL,
	[VLR_PROD_BOLSA_FAMILIA] [money] NULL,
 CONSTRAINT [PK_EST_PROD_FARMACIA_POPULAR] PRIMARY KEY CLUSTERED 
(
	[CD_EMP] ASC,
	[CD_FILIAL] ASC,
	[CD_PROD] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 97) ON [PRIMARY]
) ON [PRIMARY];

ALTER TABLE [EST_PROD_FARMACIA_POPULAR] ADD  CONSTRAINT [DF_EST_PROD_FARMACIA_POPULAR_CD_EMP]  DEFAULT ((0)) FOR [CD_EMP];


ALTER TABLE [EST_PROD_FARMACIA_POPULAR] ADD  CONSTRAINT [DF_EST_PROD_FARMACIA_POPULAR_CD_PROD]  DEFAULT ((0)) FOR [CD_PROD];

ALTER TABLE [EST_PROD_FARMACIA_POPULAR] ADD  CONSTRAINT [DF_EST_PROD_FARMACIA_POPULAR_QT_COMPR_EMB_CX]  DEFAULT ((0)) FOR [QT_COMPR_EMB_CX];

ALTER TABLE [EST_PROD_FARMACIA_POPULAR] ADD  CONSTRAINT [DF_EST_PROD_FARMACIA_POPULAR_CD_USU]  DEFAULT ((0)) FOR [CD_USU];

ALTER TABLE [EST_PROD_FARMACIA_POPULAR] ADD  CONSTRAINT [DF_EST_PROD_FARMACIA_POPULAR_EAN_PADRAO]  DEFAULT ('') FOR [EAN_PADRAO];

ALTER TABLE [EST_PROD_FARMACIA_POPULAR] ADD  CONSTRAINT [DF_EST_PROD_FARMACIA_POPULAR_VLR_PROD]  DEFAULT ((0)) FOR [VLR_PROD];

ALTER TABLE [EST_PROD_FARMACIA_POPULAR] ADD  CONSTRAINT [DF_EST_PROD_FARMACIA_POPULAR_FLAG_TIPO_PRECO]  DEFAULT ((0)) FOR [FLAG_TIPO_PRECO];

ALTER TABLE [EST_PROD_FARMACIA_POPULAR] ADD  DEFAULT ((1)) FOR [CD_FILIAL];


ALTER TABLE [EST_PROD_FARMACIA_POPULAR]  WITH CHECK ADD  CONSTRAINT [FK_EST_PROD_FARMACIA_POPULAR_EST_PROD] FOREIGN KEY([CD_EMP], [CD_PROD])
REFERENCES [EST_PROD] ([CD_EMP], [CD_PROD])
ON UPDATE CASCADE;

ALTER TABLE [EST_PROD_FARMACIA_POPULAR] CHECK CONSTRAINT [FK_EST_PROD_FARMACIA_POPULAR_EST_PROD];

ALTER TABLE [EST_PROD_FARMACIA_POPULAR]  WITH CHECK ADD  CONSTRAINT [FK_EST_PROD_FARMACIA_POPULAR_GLB_USU] FOREIGN KEY([CD_USU])
REFERENCES [GLB_USU] ([CD_USU])
ON UPDATE CASCADE;

ALTER TABLE [EST_PROD_FARMACIA_POPULAR] CHECK CONSTRAINT [FK_EST_PROD_FARMACIA_POPULAR_GLB_USU]

END

